/*
 * Decompiled with CFR 0.152.
 */
package dev.felnull.otyacraftengine.client.motion;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Vector3f;
import dev.felnull.otyacraftengine.client.util.OERenderUtil;
import dev.felnull.otyacraftengine.util.OEMath;
import org.apache.commons.lang3.tuple.Triple;
import org.jetbrains.annotations.NotNull;

public record MotionRotation(Vector3f angle, Vector3f origin, Triple<Boolean, Boolean, Boolean> reset) {
    public MotionRotation(float ax, float ay, float az, float ox, float oy, float oz, boolean rx, boolean ry, boolean rz) {
        this(new Vector3f(ax, ay, az), new Vector3f(ox, oy, oz), (Triple<Boolean, Boolean, Boolean>)Triple.of((Object)rx, (Object)ry, (Object)rz));
    }

    public MotionRotation() {
        this(new Vector3f(), new Vector3f(), (Triple<Boolean, Boolean, Boolean>)Triple.of((Object)false, (Object)false, (Object)false));
    }

    public MotionRotation copy() {
        return new MotionRotation(this.angle.m_122281_(), this.origin.m_122281_(), this.reset);
    }

    public MotionRotation add(MotionRotation rotation) {
        return OEMath.add(this, rotation);
    }

    public static MotionRotation of(JsonObject jo) {
        JsonArray ja = jo.getAsJsonArray("angle");
        JsonArray jc = jo.getAsJsonArray("origin");
        JsonArray jr = jo.getAsJsonArray("reset");
        Triple res = Triple.of((Object)false, (Object)false, (Object)false);
        if (jr != null) {
            res = Triple.of((Object)jr.get(0).getAsBoolean(), (Object)jr.get(1).getAsBoolean(), (Object)jr.get(2).getAsBoolean());
        }
        return new MotionRotation(new Vector3f(ja.get(0).getAsFloat(), ja.get(1).getAsFloat(), ja.get(2).getAsFloat()), new Vector3f(jc.get(0).getAsFloat(), jc.get(1).getAsFloat(), jc.get(2).getAsFloat()), (Triple<Boolean, Boolean, Boolean>)res);
    }

    public JsonObject toJson() {
        JsonObject jo = new JsonObject();
        JsonArray a = new JsonArray();
        a.add((Number)Float.valueOf(this.angle.m_122239_()));
        a.add((Number)Float.valueOf(this.angle.m_122260_()));
        a.add((Number)Float.valueOf(this.angle.m_122269_()));
        jo.add("angle", (JsonElement)a);
        JsonArray c = new JsonArray();
        c.add((Number)Float.valueOf(this.origin.m_122239_()));
        c.add((Number)Float.valueOf(this.origin.m_122260_()));
        c.add((Number)Float.valueOf(this.origin.m_122269_()));
        jo.add("origin", (JsonElement)c);
        if (!(((Boolean)this.reset.getRight()).booleanValue() || ((Boolean)this.reset.getMiddle()).booleanValue() || ((Boolean)this.reset.getLeft()).booleanValue())) {
            JsonArray r = new JsonArray();
            r.add((Boolean)this.reset.getLeft());
            r.add((Boolean)this.reset.getMiddle());
            r.add((Boolean)this.reset.getRight());
            jo.add("reset", (JsonElement)r);
        }
        return jo;
    }

    public void pose(@NotNull PoseStack poseStack) {
        poseStack.m_85837_((double)this.origin.m_122239_(), (double)this.origin.m_122260_(), (double)this.origin.m_122269_());
        OERenderUtil.poseRotateAll(poseStack, this.angle.m_122239_(), this.angle.m_122260_(), this.angle.m_122269_());
        poseStack.m_85837_((double)(-this.origin.m_122239_()), (double)(-this.origin.m_122260_()), (double)(-this.origin.m_122269_()));
    }
}

